/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.cim.provider.pi;

import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.exceptions.PIHscCmdMgrException;
import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.ByteUtilities;
import com.ibm.hsc.common.util.CmdExtendedError;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HSCLogUtils;
import com.ibm.hsc.common.util.PIParseResponse;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.fsp.FspSvrAsyncSubscription;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspCodAsyncEventData;
import com.ibm.hsc.fsp.cmdhelpers.FspFoDHistoryLog;
import com.ibm.hsc.fsp.cmdhelpers.FspFoDInfo;
import com.ibm.hsc.fsp.cmdhelpers.FspFoDOrderInfo;
import com.ibm.hsc.fsp.lockmgr.FspLockHelper;
import com.ibm.hsc.lock.Lock;
import com.ibm.hsc.objmgr.cec.OmCecLongRunningTask;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.rep.RObject;
import com.ibm.hsc.rep.RObjectId;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.snia.wbem.cim.CIMDataType;
import org.snia.wbem.cim.CIMProperty;
import org.snia.wbem.cim.CIMValue;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;
import org.snia.wbemcfg.GlobalConfig;

public class PIFoDUtils
implements OmCecLongRunningTask {
    private static final String TIMEOUT_PROPS_FILE = "/opt/hsc/data/hmc.properties";
    private static final String TIMEOUT_KEY = "CodKeyAsyncTimeoutInSec";
    private static final int DEFAULT_TIMEOUT_MSEC = 300000;
    private static final int CONF_NEEDED = 1;
    private static final int NO_CONF_NEEDED = 0;
    private static final int FOD_KEY_LENGTH = 34;
    private static final int FOD_CONFIRM_HEX_MSG = 4096;
    private static final int FOD_CONFIRM_DEC_MSG = 1000;
    private static final String COD_MSG_BUNDLE_FILE = "CoDMsgBundle";
    private static final String FOD_ADVANCED_POWER_ENABLED = "1008";
    private static final String FOD_POWER_HYP_ENABLED = "100C";
    private static final String FOD_ENTERPRISE_ENABLED = "100D";
    private static final String FOD_UNKNOWN_ENABLED = "100E";
    private static final String ADVANCED_POWER_ID = "100B";
    private static final String POWER_HYP_ID = "100F";
    private static final String ENTERPRISE_ID = "1010";
    private static final String UNKNOWN_ID = "1011";

    public static CIMValue setFoDKey(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        return new PIFoDUtils().setFoDKey1(omCecMgr, vector, vector2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMValue setFoDKey1(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        FspFoDInfo fspFoDInfo;
        Trace.trace("apcshscT", "PIFoDUtils.setFoDKey ->");
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        RObjectId rObjectId = omCecMgr.getObjectId();
        String string = omCecMgr.getCecName();
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(255);
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
        String string2 = null;
        String string3 = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, UNKNOWN_ID);
        FspSvrAsyncSubscription fspSvrAsyncSubscription = null;
        if (GlobalConfig.callMethodsWithValues) {
            unsignedInt8 = (UnsignedInt8)((CIMValue)vector.elementAt(0)).getValue();
            unsignedInt16 = (UnsignedInt16)((CIMValue)vector.elementAt(1)).getValue();
            string2 = (String)((CIMValue)vector.elementAt(2)).getValue();
        } else {
            unsignedInt8 = (UnsignedInt8)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            unsignedInt16 = (UnsignedInt16)((CIMProperty)vector.elementAt(1)).getValue().getValue();
            string2 = (String)((CIMProperty)vector.elementAt(2)).getValue().getValue();
        }
        string2 = string2.trim();
        int n = 300000;
        Properties properties = new Properties();
        int n2 = 0;
        try {
            properties.load(new FileInputStream(TIMEOUT_PROPS_FILE));
            String string4 = properties.getProperty(TIMEOUT_KEY);
            if (string4 != null) {
                n2 = Integer.parseInt(string4);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Error in reading hmc.properties file!");
        }
        if (n2 > 0) {
            n = n2 * 1000;
        }
        System.out.println("timeoutVal: " + n);
        int n3 = string2.length();
        if (n3 != 34) {
            System.out.println("Key is not right length!");
            throw new PIHscServerException("A00A", new String[]{String.valueOf(34)}, null);
        }
        int n4 = 0;
        Lock lock = Lock.getInstance("root/ibmhscS1_0", string);
        FspLockHelper fspLockHelper = new FspLockHelper(omCecMgr.getFspLockMgr(), n4);
        try {
            try {
                UnsignedInt16 unsignedInt162;
                UnsignedInt8 unsignedInt82;
                UnsignedInt32 unsignedInt32;
                block26: {
                    fspLockHelper.addCecLock(omCecMgr.getObjectId());
                    fspLockHelper.addCecCoDCodeLock(omCecMgr.getObjectId(), 64, false);
                    fspLockHelper.lock();
                    unsignedInt32 = null;
                    unsignedInt82 = null;
                    unsignedInt162 = null;
                    boolean bl = false;
                    fspSvrAsyncSubscription = omCecMgr.subscribeSvrEvent(1, 0, n);
                    if (unsignedInt16.intValue() == 1000) {
                        unsignedInt16 = new UnsignedInt16(4096);
                    }
                    System.out.println("SETTING FOD KEY!");
                    fspFoDInfo = fspCmdHelper.setFoDKey(unsignedInt8, unsignedInt16, string2);
                    System.out.println("After calling setFoDKey PHYP cmd...");
                    unsignedInt32 = fspFoDInfo.getFoDType();
                    unsignedInt82 = fspFoDInfo.getConfirmationNeededVal();
                    unsignedInt162 = fspFoDInfo.getConfirmationId();
                    if (unsignedInt82.intValue() == 0) {
                        System.out.println("No confirmation needed - get async event!");
                        System.out.println("Calling getNextEvent!()");
                        byte[] byArray = (byte[])omCecMgr.doLongRunningTask(this, new Object[]{fspSvrAsyncSubscription}, lock);
                        if (byArray == null) {
                            System.out.println("We timed out!");
                            throw new PIHscServerException("9003", null);
                        }
                        System.out.println("payload length: " + byArray.length);
                        PIParseResponse pIParseResponse = new PIParseResponse(byArray);
                        System.out.println("PIParseResponse: " + pIParseResponse);
                        FspCodAsyncEventData fspCodAsyncEventData = fspCmdHelper.getCodAsyncEventData(pIParseResponse);
                        BitSet bitSet = fspCodAsyncEventData.getEventMask();
                        if (bitSet.get(13)) {
                            System.out.println("Key processing failed in async event!");
                            throw new PIHscServerException("A009");
                        }
                        if (bitSet.get(12)) {
                            System.out.println("Key Processing succeeded!");
                        }
                        string3 = PIFoDUtils.createInfoMsg(unsignedInt32);
                        System.out.println("keyInfoMsg = " + string3);
                        break block26;
                    }
                    System.out.println("Need confirmation!");
                    System.out.println("Confirmation ID: " + unsignedInt162);
                    if (unsignedInt162.intValue() == 4096) {
                        unsignedInt162 = new UnsignedInt16(1000);
                    }
                }
                vector2.setSize(4);
                if (GlobalConfig.callMethodsWithValues) {
                    vector2.setElementAt(new CIMValue((Object)unsignedInt32), 0);
                    vector2.setElementAt(new CIMValue((Object)unsignedInt82), 1);
                    vector2.setElementAt(new CIMValue((Object)unsignedInt162), 2);
                    vector2.setElementAt(new CIMValue((Object)string3), 3);
                } else {
                    vector2.setElementAt(new CIMProperty("FoDType", new CIMValue((Object)unsignedInt32)), 0);
                    vector2.setElementAt(new CIMProperty("ConfirmationNeeded", new CIMValue((Object)unsignedInt82)), 1);
                    vector2.setElementAt(new CIMProperty("ConfirmationMsgID", new CIMValue((Object)unsignedInt162)), 2);
                    vector2.setElementAt(new CIMProperty("KeyInfoMsg", new CIMValue((Object)string3)), 3);
                }
                fspFoDInfo = new CIMValue((Object)new UnsignedInt8(0));
                Object var30_39 = null;
            }
            catch (PIHscCmdMgrException pIHscCmdMgrException) {
                System.err.println("*** Error *** - FoD Set Key");
                pIHscCmdMgrException.printStackTrace();
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                if (!pIHscCmdMgrException.isExtendedError()) {
                    if (pIHscCmdMgrException.getStatus() != 32808) throw new PIHscServerException("9001", pIHscCmdMgrException);
                    throw new PIHscServerException("9010", pIHscCmdMgrException);
                }
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PIFoDUtils.getFoDExtendedErrorMsg(cmdExtendedError);
                String string5 = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string5, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string5, stringArray2, pIHscCmdMgrException);
            }
            catch (PIHscServerException pIHscServerException) {
                pIHscServerException.printStackTrace();
                throw pIHscServerException;
            }
            catch (Throwable throwable) {
                System.out.println("Error!");
                throwable.printStackTrace();
                throw new PIHscServerException("9001", throwable);
            }
        }
        catch (Throwable throwable) {
            Object var30_40 = null;
            fspLockHelper.unlock();
            if (fspSvrAsyncSubscription == null) throw throwable;
            fspSvrAsyncSubscription.close();
            throw throwable;
        }
        fspLockHelper.unlock();
        if (fspSvrAsyncSubscription == null) return fspFoDInfo;
        fspSvrAsyncSubscription.close();
        return fspFoDInfo;
    }

    public Object performLongRunningTask(Object[] objectArray) throws Throwable {
        FspSvrAsyncSubscription fspSvrAsyncSubscription = (FspSvrAsyncSubscription)objectArray[0];
        System.out.println("Calling getNextEvent!()");
        byte[] byArray = fspSvrAsyncSubscription.getNextEvent();
        return byArray;
    }

    public static CIMValue getFoDOrderInfo(OmCecMgr omCecMgr, Vector vector, Vector vector2) throws PIHscServerException {
        Trace.trace("apcshscT", "PIFoDUtils.setFoDKey ->");
        System.out.println("PIFoDUtils.setFoDKey->");
        FspCmdHelper fspCmdHelper = omCecMgr.getCmdHelper();
        RObject rObject = omCecMgr.getObject();
        System.out.println("cmdHelper: " + fspCmdHelper);
        try {
            System.out.println("Getting info out of inParams!");
            UnsignedInt32 unsignedInt32 = GlobalConfig.callMethodsWithValues ? (UnsignedInt32)((CIMValue)vector.elementAt(0)).getValue() : (UnsignedInt32)((CIMProperty)vector.elementAt(0)).getValue().getValue();
            System.out.println("Sending command to PHYP");
            FspFoDOrderInfo fspFoDOrderInfo = fspCmdHelper.getFoDOrderInfo(unsignedInt32);
            System.out.println("Done sending command");
            UnsignedInt8 unsignedInt8 = fspFoDOrderInfo.getFormat();
            String[] stringArray = fspFoDOrderInfo.getOrderInfoList();
            System.out.println("orderInfoList: " + stringArray);
            System.out.println("length of orderInfoList: " + stringArray.length);
            vector2.setSize(2);
            if (GlobalConfig.callMethodsWithValues) {
                vector2.setElementAt(new CIMValue((Object)unsignedInt8), 0);
                vector2.setElementAt(new CIMValue((Object)stringArray, new CIMDataType(29)), 1);
            } else {
                vector2.setElementAt(new CIMProperty("Format", new CIMValue((Object)unsignedInt8)), 0);
                vector2.setElementAt(new CIMProperty("FoDOrderInfo", new CIMValue((Object)stringArray, new CIMDataType(29))), 1);
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            System.err.println("*** Error *** - Get FoD Order Info");
            pIHscCmdMgrException.printStackTrace();
            HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
            if (pIHscCmdMgrException.isExtendedError()) {
                System.out.println("We've got an extended error!");
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PIFoDUtils.getFoDExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray2 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray2, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
        catch (Throwable throwable) {
            System.out.println("Error!");
            throwable.printStackTrace();
            throw new PIHscServerException("9001", throwable);
        }
    }

    public static CIMValue getFoDHistoryLog(FspCmdHelper fspCmdHelper, Vector vector) throws PIHscServerException {
        try {
            String[] stringArray;
            FspFoDHistoryLog fspFoDHistoryLog = fspCmdHelper.getFoDHistoryLog();
            int n = fspFoDHistoryLog.getEntryCount().intValue();
            if (n != 0) {
                UnsignedInt16[] unsignedInt16Array = fspFoDHistoryLog.getFoDMsgIds();
                String[] stringArray2 = fspFoDHistoryLog.getMsgParm1s();
                String[] stringArray3 = fspFoDHistoryLog.getMsgParm2s();
                String[] stringArray4 = fspFoDHistoryLog.getMsgParm3s();
                stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    String[] stringArray5 = new String[]{stringArray2[i], stringArray3[i], stringArray4[i]};
                    stringArray[i] = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, ByteUtilities.toHexString(unsignedInt16Array[i]), null, stringArray5);
                }
            } else {
                stringArray = new String[]{"The log is empty."};
            }
            vector.setSize(9);
            if (GlobalConfig.callMethodsWithValues) {
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getLogWrappedVal(), new CIMDataType(1)), 0);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getEntryCount(), new CIMDataType(3)), 1);
                vector.setElementAt(new CIMValue((Object)stringArray, new CIMDataType(29)), 2);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getTimestampYears(), new CIMDataType(23)), 3);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getTimestampMonths(), new CIMDataType(21)), 4);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getTimestampDays(), new CIMDataType(21)), 5);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getTimestampHours(), new CIMDataType(21)), 6);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getTimestampMinutes(), new CIMDataType(21)), 7);
                vector.setElementAt(new CIMValue((Object)fspFoDHistoryLog.getTimestampSeconds(), new CIMDataType(21)), 8);
            } else {
                vector.setElementAt(new CIMProperty("LogWrapValue", new CIMValue((Object)fspFoDHistoryLog.getLogWrappedVal(), new CIMDataType(1))), 0);
                vector.setElementAt(new CIMProperty("EntryCount", new CIMValue((Object)fspFoDHistoryLog.getEntryCount(), new CIMDataType(3))), 1);
                vector.setElementAt(new CIMProperty("HistLogEntries", new CIMValue((Object)stringArray, new CIMDataType(29))), 2);
                vector.setElementAt(new CIMProperty("TimestampYearList", new CIMValue((Object)fspFoDHistoryLog.getTimestampYears(), new CIMDataType(23))), 3);
                vector.setElementAt(new CIMProperty("TimestampMonthList", new CIMValue((Object)fspFoDHistoryLog.getTimestampMonths(), new CIMDataType(21))), 4);
                vector.setElementAt(new CIMProperty("TimestampDayList", new CIMValue((Object)fspFoDHistoryLog.getTimestampDays(), new CIMDataType(21))), 5);
                vector.setElementAt(new CIMProperty("TimestampHourList", new CIMValue((Object)fspFoDHistoryLog.getTimestampHours(), new CIMDataType(21))), 6);
                vector.setElementAt(new CIMProperty("TimestampMinuteList", new CIMValue((Object)fspFoDHistoryLog.getTimestampMinutes(), new CIMDataType(21))), 7);
                vector.setElementAt(new CIMProperty("TimestampSecondList", new CIMValue((Object)fspFoDHistoryLog.getTimestampSeconds(), new CIMDataType(21))), 8);
            }
            return new CIMValue((Object)new UnsignedInt8(0));
        }
        catch (PIHscCmdMgrException pIHscCmdMgrException) {
            pIHscCmdMgrException.printStackTrace();
            if (!pIHscCmdMgrException.alreadyLogged()) {
                HSCLogUtils.serverLog(pIHscCmdMgrException, HSCLogUtils._CECClassLogInfo);
                pIHscCmdMgrException.setAlreadyLogged(true);
            }
            if (pIHscCmdMgrException.isExtendedError()) {
                CmdExtendedErrorList cmdExtendedErrorList = pIHscCmdMgrException.getExtendedError();
                CmdExtendedError cmdExtendedError = cmdExtendedErrorList.getErrorAt(0);
                String[] stringArray = PIFoDUtils.getFoDExtendedErrorMsg(cmdExtendedError);
                String string = stringArray[0];
                if (stringArray[1] == null) {
                    throw new PIHscServerException(string, pIHscCmdMgrException);
                }
                String[] stringArray6 = new String[]{stringArray[1]};
                throw new PIHscServerException(string, stringArray6, pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32808) {
                throw new PIHscServerException("9010", pIHscCmdMgrException);
            }
            if (pIHscCmdMgrException.getStatus() == 32769) {
                throw new PIHscServerException("0243", pIHscCmdMgrException);
            }
            throw new PIHscServerException("9001", pIHscCmdMgrException);
        }
    }

    private static String createInfoMsg(UnsignedInt32 unsignedInt32) {
        String string = null;
        if (unsignedInt32.intValue() == 3) {
            System.out.println("Advanced POWER Virtualization enabled!");
            string = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, FOD_ADVANCED_POWER_ENABLED);
        } else if (unsignedInt32.intValue() == 11) {
            System.out.println("POWER Hypervisor enabled!");
            string = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, FOD_POWER_HYP_ENABLED);
        } else if (unsignedInt32.intValue() == 4) {
            System.out.println("Enterprise Enablement enabled!");
            string = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, FOD_ENTERPRISE_ENABLED);
        } else {
            System.out.println("Unknown Virtualization Engine systems technologies enabled!");
            string = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, FOD_UNKNOWN_ENABLED);
        }
        return string;
    }

    private static String[] getFoDExtendedErrorMsg(CmdExtendedError cmdExtendedError) {
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        long l = cmdExtendedError.extractErrorCode();
        System.out.println("Error code: " + l);
        if (l == 0x40002004L || l == 1073750022L || l == 1073750023L || l == 1073750024L || l == 1073750025L || l == 1073750035L) {
            string2 = "";
            byte[] byArray = cmdExtendedError.getErrorParms();
            if (byArray.length != 0) {
                System.out.println("There are error params!");
                try {
                    Hashtable hashtable = PIParseResponse.parseByCmd("FOD_EXT_ERR_DATA", byArray);
                    System.out.println("Err data hashtable: " + hashtable);
                    UnsignedInt32 unsignedInt32 = (UnsignedInt32)hashtable.get("FOD_TYPE");
                    int n = unsignedInt32.intValue();
                    if (n == 3) {
                        string2 = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, ADVANCED_POWER_ID);
                    } else if (n == 11) {
                        string2 = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, POWER_HYP_ID);
                    } else if (n == 4) {
                        string2 = HSCResourceBundleUtil.encodeNLSMsg(COD_MSG_BUNDLE_FILE, ENTERPRISE_ID);
                    }
                }
                catch (IOException iOException) {
                    System.out.println("Error while parsing error data...");
                    iOException.printStackTrace();
                }
            }
        }
        if ((string = l == 0x40001001L ? "9015" : (l == 0x40002004L || l == 1073750021L || l == 1073750024L || l == 1073750037L ? "A003" : (l == 1073750022L ? "A004" : (l == 1073750023L ? "A005" : (l == 1073750025L ? "A006" : (l == 1073750035L ? "A007" : (l == 1073750041L ? "A008" : (l == 1073754114L ? "020D" : (l == 1073754117L || l == 1073766401L ? "9010" : (l == 0x40004001L ? "9003" : (l == 0x40004002L ? "1552" : (l == 0x40003004L ? "A000" : "9003")))))))))))) == null) {
            string = "9003";
        }
        stringArray = new String[]{string, string2};
        return stringArray;
    }
}

